%   Copyright  2020 University of Extremadura (UEx)
%
% getDataForSet
%  Input:
%   dataFolder: Path to the folder with the data
%   set: Current deployment information
%   phone: Selected phone index
%   nonValuteToNan: Empty measurements option
%   beacon: Selected beacon (slot)
%
%  Output:
%   data: Structure with the selected data
%   bcCoords: Beacons coordinates
% -----------------------------------------


function [data,bcCoords] = getDataForSet_old(dataFolder, set, phone, nonValueToNan, beacon)

    if (beacon == 0)
        % Data is taken from files
        [allData,bcCoords] = loadDeployment_old(set, dataFolder);   

        % Selection phone
        selectedPhone = getFilterForPhone(allData.ids,phone);
        data = applyFilter_old(allData,selectedPhone');

        if (nonValueToNan)
            data.rss(data.rss == 0) = nan;
        end
    else
         % Data is taken from files
        [allData,bcCoords] = loadDeployment(set, dataFolder);   

        % Selection phone
        selectedPhone = getFilterForPhone(allData.ids,phone);
        selectedSlot = getFilterForSlot(allData.ids,beacon);
        data = applyFilter_old(allData,selectedPhone'&selectedSlot);

        if (nonValueToNan)
            data.rss(data.rss == 0) = nan;
        end
    end
end